
/// Figure 8.1, based on Table 8.2 Model 1

clear
run CostOfSystemCompliance.do

capture drop c1-c3
logit feecomply c.lnfeeexpord##i.atty, cluster(companyname)
margins i.atty, at(lnfeeexpord=(11.1 12.3 12.7 13.1 13.6 13.9 14.5 15.1 15.8))
matrix b=r(b)'
matrix prg=(1\2\3\4\5\6\7\8\9)#(1\1)
matrix yr=(1\1\1\1\1\1\1\1\1)#(0\1)
matrix c=prg, yr, b
svmat c, names(c)
clist c1-c3 in 1/18
twoway (connect c3 c1 if c2==1)(connect c3 c1 if c2==0), ///
	title("Figure 8.1. Predicted Guideline Compliance Rate for" ///
	"Professional Firms in Large Public Company" ///
	"Bankruptcies, by Fee Application Amount (in Deciles)") ///
	xtitle("Size of Fee Application Amount (Decile)", size(large)) ytitle("Predicted Compliance Rate", size(large)) ///
	xlabel(1 "1st" 3 "3rd" 5 "5th" 7 "7th" 9"9th") ylabel(.1 "10%" .3"30%" .5"50%" .7"70%" .9"90%") ///
	legend(off) /// 
	scheme(s1mono) name(Compliance, replace)

graph export Fig8_1.eps, replace 

capture drop c1-c3
